# Brainrot UI Demo (Pure Local, Keyless)

A safe learning demo for Roblox UI built with `Instance.new` (no web requests, no key system, no external libraries).

## What’s inside
- `LearningRayfieldDemo.lua` – the full LocalScript code (pure local)
- `LICENSE` – MIT

## How to use (for your friend)
1. Open **Roblox Studio** and your place.
2. In **Explorer** create a **LocalScript** under:
   - `StarterPlayer > StarterPlayerScripts` *(recommended)*, or
   - `StarterGui`
3. Copy **all** contents of `LearningRayfieldDemo.lua` and paste into the LocalScript.
4. Click **Play**.
   - Press **K** to toggle the UI.
   - Use left tabs to switch pages.
   - Buttons will print to Output / show small animations.

## Teach them in one message (copy/paste)
> Download the zip, unzip, open `LearningRayfieldDemo.lua`, copy all, then in Studio create a LocalScript under `StarterPlayerScripts` and paste. Press **K** in Play mode to show/hide. It’s fully local and safe for learning.

## Optional: Publish as a public Model (Toolbox install)
1. In Studio, create a **ScreenGui** under `StarterGui`, add a **LocalScript** inside it and paste the code.
2. Select the ScreenGui and **right‑click → Save to Roblox…** (or *Publish as Model*).
3. Fill in name, description, icon, **set permissions** to *Public*.
4. Share the **asset link** or **Toolbox search name** with friends.  
   They can **Toolbox → My Models / Creator Marketplace** and insert it.

## Troubleshooting
- Nothing shows? Make sure it’s a **LocalScript** in `StarterPlayerScripts` (or `StarterGui`) — not a Server Script.
- UI blocked by top bar? The demo uses `IgnoreGuiInset = false`; change to `true` if desired.
- Key K doesn’t work? Check if another script captures K; you can change the toggle key inside the script (search `Enum.KeyCode.K`).

## License
MIT – do whatever you want, just keep the license.
