--[[
  🧠 Steal A Brainrot Memers — 可视化 UI 学习版（纯本地）
  - 无任何联网/Key 校验/外部库
  - 使用 Instance.new 构建 UI
  - 支持按 K 显隐
  - 结构：Window → Tabs → Buttons（演示）
  放置位置：StarterPlayer > StarterPlayerScripts（LocalScript）
]]]

-- 服务引用
local Players = game:GetService("Players")
local TweenService = game:GetService("TweenService")
local UserInputService = game:GetService("UserInputService")

local player = Players.LocalPlayer

-- ========= 基础 UI 工具 =========
local function create(className, props, children)
    local inst = Instance.new(className)
    for k, v in pairs(props or {}) do
        inst[k] = v
    end
    for _, child in ipairs(children or {}) do
        child.Parent = inst
    end
    return inst
end

-- 颜色 & 样式
local COLORS = {
    bg       = Color3.fromRGB(18, 18, 20),
    panel    = Color3.fromRGB(28, 28, 32),
    stroke   = Color3.fromRGB(60, 60, 68),
    accent   = Color3.fromRGB(130, 160, 255),
    text     = Color3.fromRGB(235, 235, 240),
    subtext  = Color3.fromRGB(180, 180, 190),
    success  = Color3.fromRGB(80, 200, 120),
    hover    = Color3.fromRGB(40, 40, 48),
}

-- ========= ScreenGui =========
local screenGui = create("ScreenGui", {
    Name = "LearningRayfieldDemo",
    ZIndexBehavior = Enum.ZIndexBehavior.Sibling,
    ResetOnSpawn = false,
    IgnoreGuiInset = false,
}, {})

-- 优先放到 PlayerGui（在 Studio/客户端都可见）
screenGui.Parent = player:WaitForChild("PlayerGui")

-- ========= 主窗口 =========
local mainFrame = create("Frame", {
    Name = "MainFrame",
    BackgroundColor3 = COLORS.bg,
    Size = UDim2.new(0, 640, 0, 400),
    Position = UDim2.new(0.5, -320, 0.5, -200),
    AnchorPoint = Vector2.new(0.5, 0.5),
    Active = true,
    Draggable = true,
}, {
    create("UICorner", {CornerRadius = UDim.new(0, 12)}, {}),
    create("UIStroke", {Color = COLORS.stroke, Thickness = 1.5, ApplyStrokeMode = Enum.ApplyStrokeMode.Border}, {})
})

-- 阴影（简易）
local shadow = create("ImageLabel", {
    Name = "Shadow",
    BackgroundTransparency = 1,
    Image = "rbxassetid://5028857084",
    ImageColor3 = Color3.fromRGB(0,0,0),
    ImageTransparency = 0.4,
    ScaleType = Enum.ScaleType.Slice,
    SliceCenter = Rect.new(24,24,276,276),
    Size = UDim2.new(1, 40, 1, 40),
    Position = UDim2.new(0, -20, 0, -20),
    ZIndex = 0
}, {})
shadow.Parent = mainFrame

-- ========= 标题栏 =========
local titleBar = create("Frame", {
    Name = "TitleBar",
    BackgroundColor3 = COLORS.panel,
    Size = UDim2.new(1, 0, 0, 44),
}, {
    create("UICorner", {CornerRadius = UDim.new(0, 12)}, {}),
    create("UIStroke", {Color = COLORS.stroke, Thickness = 1}, {}),
})

titleBar.Parent = mainFrame

local titleLabel = create("TextLabel", {
    Name = "Title",
    BackgroundTransparency = 1,
    Text = "🧠 Steal A Brainrot — 学习版 UI Demo",
    Font = Enum.Font.GothamBold,
    TextSize = 18,
    TextColor3 = COLORS.text,
    TextXAlignment = Enum.TextXAlignment.Left,
    Position = UDim2.new(0, 16, 0, 0),
    Size = UDim2.new(1, -160, 1, 0)
}, {})
titleLabel.Parent = titleBar

local subtitleLabel = create("TextLabel", {
    Name = "Subtitle",
    BackgroundTransparency = 1,
    Text = "Window → Tabs → Buttons | 按 K 显隐",
    Font = Enum.Font.Gotham,
    TextSize = 13,
    TextColor3 = COLORS.subtext,
    TextXAlignment = Enum.TextXAlignment.Left,
    Position = UDim2.new(0, 16, 0, 22),
    Size = UDim2.new(1, -160, 1, -22)
}, {})
subtitleLabel.Parent = titleBar

-- 关闭 & 最小化按钮
local closeBtn = create("TextButton", {
    Name = "Close",
    BackgroundColor3 = COLORS.panel,
    Text = "✕",
    Font = Enum.Font.GothamBold,
    TextSize = 16,
    TextColor3 = COLORS.subtext,
    Size = UDim2.new(0, 36, 0, 28),
    Position = UDim2.new(1, -44, 0, 8),
    AutoButtonColor = false,
}, {
    create("UICorner", {CornerRadius = UDim.new(0, 8)}, {}),
    create("UIStroke", {Color = COLORS.stroke, Thickness = 1}, {})
})
closeBtn.Parent = titleBar

local miniBtn = create("TextButton", {
    Name = "Minimize",
    BackgroundColor3 = COLORS.panel,
    Text = "—",
    Font = Enum.Font.GothamBold,
    TextSize = 16,
    TextColor3 = COLORS.subtext,
    Size = UDim2.new(0, 36, 0, 28),
    Position = UDim2.new(1, -84, 0, 8),
    AutoButtonColor = false,
}, {
    create("UICorner", {CornerRadius = UDim.new(0, 8)}, {}),
    create("UIStroke", {Color = COLORS.stroke, Thickness = 1}, {})
})
miniBtn.Parent = titleBar

-- ========= 左侧 Tabs =========
local tabsPanel = create("Frame", {
    Name = "Tabs",
    BackgroundColor3 = COLORS.panel,
    Size = UDim2.new(0, 160, 1, -44),
    Position = UDim2.new(0, 0, 0, 44),
}, {
    create("UIStroke", {Color = COLORS.stroke, Thickness = 1}, {})
})
tabsPanel.Parent = mainFrame

local tabsList = create("UIListLayout", {
    Padding = UDim.new(0, 8),
    FillDirection = Enum.FillDirection.Vertical,
    HorizontalAlignment = Enum.HorizontalAlignment.Center,
    VerticalAlignment = Enum.VerticalAlignment.Top,
    SortOrder = Enum.SortOrder.LayoutOrder,
}, {})
tabsList.Parent = tabsPanel

local function makeTabButton(text, order)
    local btn = create("TextButton", {
        BackgroundColor3 = COLORS.bg,
        Size = UDim2.new(1, -16, 0, 36),
        Position = UDim2.new(0, 8, 0, 8),
        Text = text,
        TextColor3 = COLORS.text,
        Font = Enum.Font.Gotham,
        TextSize = 14,
        AutoButtonColor = false,
        LayoutOrder = order or 1,
    }, {
        create("UICorner", {CornerRadius = UDim.new(0, 8)}, {}),
        create("UIStroke", {Color = COLORS.stroke, Thickness = 1}, {})
    })

    btn.MouseEnter:Connect(function()
        TweenService:Create(btn, TweenInfo.new(0.12), {BackgroundColor3 = COLORS.hover}):Play()
    end)
    btn.MouseLeave:Connect(function()
        TweenService:Create(btn, TweenInfo.new(0.12), {BackgroundColor3 = COLORS.bg}):Play()
    end)

    return btn
end

local tabMainBtn = makeTabButton("主要功能", 1)
tabMainBtn.Parent = tabsPanel

local tabAboutBtn = makeTabButton("关于/说明", 2)
tabAboutBtn.Parent = tabsPanel

-- ========= 右侧 内容容器 =========
local contentPanel = create("Frame", {
    Name = "Content",
    BackgroundColor3 = COLORS.panel,
    Size = UDim2.new(1, -160, 1, -44),
    Position = UDim2.new(0, 160, 0, 44),
}, {
    create("UIStroke", {Color = COLORS.stroke, Thickness = 1}, {}),
})
contentPanel.Parent = mainFrame

-- 容器切换管理
local pages = {}

local function showPage(name)
    for key, page in pairs(pages) do
        page.Visible = (key == name)
    end
end

-- ========= Page: Main =========
local pageMain = create("Frame", {
    Name = "PageMain",
    BackgroundTransparency = 1,
    Size = UDim2.new(1, -24, 1, -24),
    Position = UDim2.new(0, 12, 0, 12),
    Visible = true
}, {})
pageMain.Parent = contentPanel
pages["Main"] = pageMain

local mainTitle = create("TextLabel", {
    BackgroundTransparency = 1,
    Text = "主要功能（Demo）",
    TextColor3 = COLORS.text,
    Font = Enum.Font.GothamBold,
    TextSize = 20,
    TextXAlignment = Enum.TextXAlignment.Left,
    Size = UDim2.new(1, 0, 0, 28),
}, {})
mainTitle.Parent = pageMain

local mainDesc = create("TextLabel", {
    BackgroundTransparency = 1,
    Text = "这里演示 Rayfield 风格层级：Window → Tab → Button。\\n下面的按钮只做本地回调（打印/小动画），安全可学习。",
    TextColor3 = COLORS.subtext,
    Font = Enum.Font.Gotham,
    TextSize = 14,
    TextXAlignment = Enum.TextXAlignment.Left,
    TextYAlignment = Enum.TextYAlignment.Top,
    Size = UDim2.new(1, 0, 0, 44),
    Position = UDim2.new(0, 0, 0, 30)
}, {})
mainDesc.Parent = pageMain

-- 按钮容器
local btnHolder = create("Frame", {
    BackgroundTransparency = 1,
    Size = UDim2.new(1, 0, 1, -88),
    Position = UDim2.new(0, 0, 0, 80),
}, {
    create("UIListLayout", {
        Padding = UDim.new(0, 10),
        FillDirection = Enum.FillDirection.Vertical,
        HorizontalAlignment = Enum.HorizontalAlignment.Left,
        VerticalAlignment = Enum.VerticalAlignment.Top,
        SortOrder = Enum.SortOrder.LayoutOrder
    }, {})
})
btnHolder.Parent = pageMain

local function makePrimaryButton(text, callback)
    local b = create("TextButton", {
        BackgroundColor3 = COLORS.bg,
        Size = UDim2.new(0, 240, 0, 38),
        Text = text,
        TextColor3 = COLORS.text,
        Font = Enum.Font.Gotham,
        TextSize = 14,
        AutoButtonColor = false,
    }, {
        create("UICorner", {CornerRadius = UDim.new(0, 8)}, {}),
        create("UIStroke", {Color = COLORS.stroke, Thickness = 1}, {})
    })
    b.MouseEnter:Connect(function()
        TweenService:Create(b, TweenInfo.new(0.12), {BackgroundColor3 = COLORS.hover}):Play()
    end)
    b.MouseLeave:Connect(function()
        TweenService:Create(b, TweenInfo.new(0.12), {BackgroundColor3 = COLORS.bg}):Play()
    end)
    b.MouseButton1Click:Connect(function()
        TweenService:Create(b, TweenInfo.new(0.08), {BackgroundColor3 = COLORS.accent}):Play()
        task.wait(0.1)
        TweenService:Create(b, TweenInfo.new(0.2), {BackgroundColor3 = COLORS.bg}):Play()

        if typeof(callback) == "function" then
            callback()
        end
    end)
    return b
end

-- 示例按钮 1：打印
makePrimaryButton("点击我！（打印示例）", function()
    print("✅ [Demo] 你点击了按钮：打印成功！")
end).Parent = btnHolder

-- 示例按钮 2：状态提示
local statusLabel = create("TextLabel", {
    BackgroundTransparency = 1,
    Text = "当前状态：Idle",
    TextColor3 = COLORS.subtext,
    Font = Enum.Font.Gotham,
    TextSize = 14,
    TextXAlignment = Enum.TextXAlignment.Left,
    Size = UDim2.new(0, 240, 0, 24),
}, {})
statusLabel.Parent = btnHolder

makePrimaryButton("执行一个假任务（1s）", function()
    statusLabel.Text = "当前状态：Running..."
    task.delay(1, function()
        statusLabel.Text = "当前状态：✅ Completed"
        statusLabel.TextColor3 = COLORS.success
    end)
end).Parent = btnHolder

-- ========= Page: About =========
local pageAbout = create("Frame", {
    Name = "PageAbout",
    BackgroundTransparency = 1,
    Size = UDim2.new(1, -24, 1, -24),
    Position = UDim2.new(0, 12, 0, 12),
    Visible = false
}, {})
pageAbout.Parent = contentPanel
pages["About"] = pageAbout

local aboutText = create("TextLabel", {
    BackgroundTransparency = 1,
    Text = "关于本 Demo\\n\\n• 完全本地，无联网/Key/外部库\\n• 目的：学习 Roblox UI 层级与交互\\n• 你可以仿照这里继续加：Toggle、Slider、Dropdown 等\\n• 按 K 随时显示/隐藏窗口",
    TextWrapped = true,
    TextColor3 = COLORS.text,
    Font = Enum.Font.Gotham,
    TextSize = 14,
    TextXAlignment = Enum.TextXAlignment.Left,
    TextYAlignment = Enum.TextYAlignment.Top,
    Size = UDim2.new(1, 0, 1, 0),
}, {})
aboutText.Parent = pageAbout

-- Tab 切换行为
local function selectTab(which)
    if which == "Main" then
        TweenService:Create(tabMainBtn, TweenInfo.new(0.12), {BackgroundColor3 = COLORS.accent}):Play()
        TweenService:Create(tabAboutBtn, TweenInfo.new(0.12), {BackgroundColor3 = COLORS.bg}):Play()
        showPage("Main")
    else
        TweenService:Create(tabAboutBtn, TweenInfo.new(0.12), {BackgroundColor3 = COLORS.accent}):Play()
        TweenService:Create(tabMainBtn, TweenInfo.new(0.12), {BackgroundColor3 = COLORS.bg}):Play()
        showPage("About")
    end
end
tabMainBtn.MouseButton1Click:Connect(function() selectTab("Main") end)
tabAboutBtn.MouseButton1Click:Connect(function() selectTab("About") end)
selectTab("Main")

-- ========= 显隐控制（K 键） =========
local visible = true
local function setVisible(show)
    visible = show
    if show then
        mainFrame.Visible = true
        mainFrame.BackgroundTransparency = 1
        TweenService:Create(mainFrame, TweenInfo.new(0.18), {BackgroundTransparency = 0}):Play()
    else
        TweenService:Create(mainFrame, TweenInfo.new(0.18), {BackgroundTransparency = 1}):Play()
        task.delay(0.2, function()
            if not visible then mainFrame.Visible = false end
        end)
    end
end

UserInputService.InputBegan:Connect(function(input, gameProcessed)
    if gameProcessed then return end
    if input.KeyCode == Enum.KeyCode.K then
        setVisible(not visible)
    end
end)

-- 关闭/最小化
closeBtn.MouseButton1Click:Connect(function()
    setVisible(false)
end)
miniBtn.MouseButton1Click:Connect(function()
    TweenService:Create(mainFrame, TweenInfo.new(0.18), {Size = UDim2.new(0, 640, 0, 44)}):Play()
    task.delay(0.2, function()
        contentPanel.Visible = false
        tabsPanel.Visible = false
    end)
end)

-- 双击标题栏还原最小化
local lastClick = 0
titleBar.InputBegan:Connect(function(input)
    if input.UserInputType == Enum.UserInputType.MouseButton1 then
        local now = tick()
        if now - lastClick < 0.3 then
            contentPanel.Visible = true
            tabsPanel.Visible = true
            TweenService:Create(mainFrame, TweenInfo.new(0.18), {Size = UDim2.new(0, 640, 0, 400)}):Play()
        end
        lastClick = now
    end
end)
